<?= $this->extend('layouts/app') ?>

<?= $this->section('main') ?>
<div class="container-fluid mt-4">

    <div class="row mb-4 align-items-center">
        <div class="col-12 col-lg-auto mb-3 mb-lg-0">
            <h1 class="h3 mb-0 text-gray-800"><i class="bi bi-calendar-week"></i> Ders Programım</h1>
        </div>
        <div class="col-12 col-lg-auto ms-lg-auto d-lg-none">
            <div class="btn-group w-100" role="group">
                <button id="prevDayBtn" class="btn btn-outline-success"><i class="bi bi-chevron-left"></i> Önceki Gün</button>
                <button id="todayBtn" class="btn btn-success">Bugün</button>
                <button id="nextDayBtn" class="btn btn-outline-success">Sonraki Gün <i class="bi bi-chevron-right"></i></button>
            </div>
        </div>
    </div>
    
    <?php 
        // Gerekli PHP değişkenlerini hazırlayalım
        $dayNames = ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'];
    ?>

    <div class="card shadow d-none d-lg-block">
        <div class="card-body p-2 p-md-3">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="table-light text-center align-middle">
                        <tr>
                            <th style="width: 100px;">Saat</th>
                            <?php foreach ($weekDates as $day): ?>
                                <th class="<?= ($day->format('Y-m-d') == date('Y-m-d')) ? 'table-success' : '' ?>">
                                    <div><?= esc($dayNames[$day->format('w')]) ?></div>
                                    <small class="fw-normal"><?= $day->format('d.m.Y') ?></small>
                                </th>
                            <?php endforeach; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php for ($hour = config('Ots')->scheduleStartHour; $hour < config('Ots')->scheduleEndHour; $hour++): 
                            $time = str_pad($hour, 2, '0', STR_PAD_LEFT) . ':00';
                        ?>
                        <tr>
                            <td class="fw-bold text-center align-middle bg-light"><?= $time ?></td>
                            <?php foreach ($weekDates as $day): 
                                $dateKey = $day->format('Y-m-d');
                                $itemsInSlot = $scheduleData[$dateKey][$time] ?? [];
                            ?>
                            <td class="p-1 align-top" style="min-width: 150px;">
                                <?php if (!empty($itemsInSlot)): ?>
                                    <div class="list-group list-group-flush">
                                        <?php foreach ($itemsInSlot as $item): ?>
                                            <?php if ($item['type'] === 'lesson'): ?>
                                                <a href="<?= site_url('students/' . $item['student_id']) ?>" class="list-group-item list-group-item-action p-2" data-bs-toggle="tooltip" title="<?= esc(date('H:i', strtotime($item['start_time']))) ?> - <?= esc(date('H:i', strtotime($item['end_time']))) ?>">
                                                    <div class="d-flex align-items-center">
                                                        <img src="<?= base_url($item['profile_image'] ?? 'assets/images/user.jpg') ?>" class="rounded-circle me-2" alt="<?= esc($item['adi']) ?>" style="width:28px; height:28px; object-fit:cover;">
                                                        <small class="text-truncate"><?= esc($item['adi'] . ' ' . $item['soyadi']) ?></small>
                                                    </div>
                                                </a>
                                            <?php elseif ($item['type'] === 'evaluation'): ?>
                                                <a href="#" class="list-group-item list-group-item-action p-2 bg-info-subtle has-evaluation" data-evaluation-id="<?= $item['id'] ?>" data-bs-toggle="tooltip" title="<?= esc(date('H:i', strtotime($item['start_time']))) ?> - <?= esc(date('H:i', strtotime($item['end_time']))) ?>">
                                                    <div class="d-flex align-items-center">
                                                        <i class="bi bi-card-checklist me-2"></i>
                                                        <small class="text-truncate">DEĞERLENDİRME</small>
                                                    </div>
                                                </a>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <?php endforeach; ?>
                        </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="d-lg-none">
        <div class="card shadow">
            <div id="mobileDateHeader" class="card-header text-center fw-bold fs-5">
                </div>
            <ul id="mobileLessonList" class="list-group list-group-flush">
                </ul>
        </div>
    </div>
</div>

<div class="modal fade" id="evaluationDetailModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="evaluationDetailModalLabel">Değerlendirme Detayları</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="evaluation-form">
                    <input type="hidden" name="evaluation_id" id="evaluationId">
                    <div class="mb-3">
                        <label for="evaluationNotes" class="form-label">Notlar</label>
                        <textarea class="form-control" id="evaluationNotes" name="notes" rows="5"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                <button type="button" class="btn btn-danger" id="deleteEvaluationBtn">Değerlendirmeyi Sil</button>
                <button type="button" class="btn btn-primary" id="updateEvaluationNotesBtn">Notları Kaydet</button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('pageScripts') ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // --------------------------------------------------------------------
    // BÖLÜM 1: PHP'den Gelen Haftalık Veriyi JavaScript'e Aktarma
    // --------------------------------------------------------------------
    const weeklyScheduleData = <?= json_encode($scheduleData) ?>;
    const weekDates = <?= json_encode(array_map(fn($d) => $d->format('Y-m-d'), $weekDates)) ?>;
    const dayNames = ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'];
    const todayString = new Date().toISOString().split('T')[0];

    let currentDayIndex = weekDates.indexOf('<?= $currentDate->format('Y-m-d') ?>');
    if (currentDayIndex === -1) {
        currentDayIndex = 0;
    }

    // --------------------------------------------------------------------
    // BÖLÜM 2: Gerekli HTML Elementlerini Seçme
    // --------------------------------------------------------------------
    const prevDayBtn = document.getElementById('prevDayBtn');
    const nextDayBtn = document.getElementById('nextDayBtn');
    const todayBtn = document.getElementById('todayBtn');
    const mobileDateHeader = document.getElementById('mobileDateHeader');
    const mobileLessonList = document.getElementById('mobileLessonList');

    // --------------------------------------------------------------------
    // BÖLÜM 3: Mobil Arayüzü Dinamik Olarak Çizen Ana Fonksiyon
    // --------------------------------------------------------------------
    function renderDay(index) {
        const dateString = weekDates[index];
        const dateObj = new Date(dateString + 'T00:00:00');
        const dayLessons = weeklyScheduleData[dateString] || {};

        // Başlığı güncelle
        const isToday = (dateString === todayString);
        mobileDateHeader.innerHTML = `
            ${dayNames[dateObj.getDay()]}
            <small class="d-block fw-normal fs-6">${dateObj.toLocaleDateString('tr-TR', { day: '2-digit', month: '2-digit', year: 'numeric' })}</small>
        `;
        mobileDateHeader.className = `card-header text-center fw-bold fs-5 ${isToday ? 'bg-success text-white' : 'bg-light'}`;
        
        // Ders listesini temizle ve yeniden oluştur
        mobileLessonList.innerHTML = '';
        let hasLessons = false;
        let listHtml = '';

        for (let hour = 8; hour <= 18; hour++) {
            const time = String(hour).padStart(2, '0') + ':00';
            const lessonsInHour = dayLessons[time] || [];
            
            let hourHtml = '';
            if (lessonsInHour.length > 0) {
                hasLessons = true;
                lessonsInHour.forEach(item => { // 'lesson' yerine 'item' adını kullandım, daha genel olması için
                    const startTime = item.start_time.substring(0, 5);
                    const endTime = item.end_time.substring(0, 5);
                    if (item.type === 'lesson') {
                        // Ders Kartı
                        const studentUrl = `<?= site_url('students') ?>/${item.student_id}`;
                        const profileImage = `<?= base_url() ?>${item.profile_image || 'assets/images/user.jpg'}`;

                        hourHtml += `
                            <a href="${studentUrl}" class="text-decoration-none text-body">
                                <div class="d-flex align-items-center p-2 rounded mb-1 bg-light">
                                    <img src="${profileImage}" class="rounded-circle me-3" alt="${item.adi}" style="width:36px; height:36px; object-fit:cover;">
                                    <div class="text-truncate">
                                        <span class="fw-bold">${item.adi} ${item.soyadi}</span>
                                        <small class="d-block text-muted">${startTime} - ${endTime}</small>
                                    </div>
                                </div>
                            </a>`;
                    } else if (item.type === 'evaluation') {
                        hourHtml += `
                            <a href="#" class="text-decoration-none text-body has-evaluation" data-evaluation-id="${item.id}" data-bs-toggle="tooltip" title="${startTime} - ${endTime}">
                                <div class="d-flex align-items-center p-2 rounded mb-1 bg-info-subtle">
                                    <i class="bi bi-card-checklist me-3 fs-5"></i>
                                    <div class="text-truncate">
                                        <span class="fw-bold">DEĞERLENDİRME</span>
                                        <small class="d-block text-muted">${startTime} - ${endTime}</small>
                                    </div>
                                </div>
                            </a>`;
                    }
                });
            }

            listHtml += `
                <li class="list-group-item d-flex p-2">
                    <div class="fw-bold text-center text-muted me-3 border-end pe-3" style="width: 60px;">${time}</div>
                    <div class="flex-grow-1">${hourHtml}</div>
                </li>`;
        }

        if (!hasLessons) {
            mobileLessonList.innerHTML = `<li class="list-group-item p-4 text-center text-muted">Bu gün için planlanmış ders bulunmamaktadır.</li>`;
        } else {
            mobileLessonList.innerHTML = listHtml;
        }

        // Butonların durumunu güncelle
        prevDayBtn.disabled = (index === 0);
        nextDayBtn.disabled = (index === weekDates.length - 1);
    }

    // --------------------------------------------------------------------
    // BÖLÜM 4: Butonlara Tıklama Olaylarını Atama
    // --------------------------------------------------------------------
    prevDayBtn.addEventListener('click', () => {
        if (currentDayIndex > 0) {
            currentDayIndex--;
            renderDay(currentDayIndex);
        }
    });

    nextDayBtn.addEventListener('click', () => {
        if (currentDayIndex < weekDates.length - 1) {
            currentDayIndex++;
            renderDay(currentDayIndex);
        }
    });

    todayBtn.addEventListener('click', () => {
        let todayIdx = weekDates.indexOf(todayString);
        if(todayIdx !== -1) {
            currentDayIndex = todayIdx;
            renderDay(currentDayIndex);
        } else {
            // Eğer bugün o haftada değilse, haftanın ilk gününü gösterelim
            currentDayIndex = 0;
            renderDay(currentDayIndex);
        }
    });

    // Sayfa ilk yüklendiğinde mevcut günü çiz
    renderDay(currentDayIndex);

    // Yeni Değerlendirme Detay Modalını başlat
    const evaluationDetailModal = new bootstrap.Modal(document.getElementById('evaluationDetailModal'));

    // Değerlendirme bloğuna tıklama olayı
    $(document).on('click', '.has-evaluation', function() {
        const evaluationId = $(this).data('evaluation-id');
        $('#evaluationId').val(evaluationId);
        $('#evaluationNotes').val('Yükleniyor...').prop('disabled', true);
        evaluationDetailModal.show();

        $.get(`<?= site_url("degerlendirme/get/") ?>${evaluationId}`)
            .done(function(response) {
                if (response.success && response.data) {
                    $('#evaluationNotes').val(response.data.notes || '').prop('disabled', false);
                } else {
                    $('#evaluationNotes').val('Notlar yüklenemedi.').prop('disabled', true);
                    alert(response.message || 'Değerlendirme detayları alınamadı.');
                }
            })
            .fail(function() {
                $('#evaluationNotes').val('Sunucu hatası.').prop('disabled', true);
                alert('Değerlendirme detayları alınırken sunucu hatası oluştu.');
            });
    });

    // Değerlendirme Notlarını Kaydet butonu
    $('#updateEvaluationNotesBtn').on('click', function() {
        const evaluationId = $('#evaluationId').val();
        const notes = $('#evaluationNotes').val();
        const button = $(this);
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Kaydediliyor...');

        $.post(`<?= site_url("degerlendirme/update/") ?>${evaluationId}`, {
            '<?= csrf_token() ?>': '<?= csrf_hash() ?>',
            notes: notes
        })
        .done(function(response) {
            if (response.success) {
                alert(response.message);
                evaluationDetailModal.hide();
                // Sayfayı yenilemek yerine sadece ilgili günün verisini yenilemek daha iyi olabilir.
                // Şimdilik tam sayfa yenileme yapıyoruz.
                location.reload(); 
            } else {
                alert(response.message || 'Notlar güncellenirken bir hata oluştu.');
            }
        })
        .fail(function() {
            alert('Sunucu hatası: Notlar güncellenemedi.');
        })
        .always(function() {
            button.prop('disabled', false).html('Notları Kaydet');
        });
    });

    // Değerlendirmeyi Sil butonu
    $('#deleteEvaluationBtn').on('click', function() {
        if (!confirm('Bu değerlendirmeyi kalıcı olarak silmek istediğinizden emin misiniz?')) return;

        const evaluationId = $('#evaluationId').val();
        const button = $(this);
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Siliniyor...');

        $.post(`<?= site_url("degerlendirme/delete/") ?>${evaluationId}`, {
            '<?= csrf_token() ?>': '<?= csrf_hash() ?>'
        })
        .done(function(response) {
            if (response.success) {
                alert(response.message);
                evaluationDetailModal.hide();
                // Sayfayı yenilemek yerine sadece ilgili günün verisini yenilemek daha iyi olabilir.
                // Şimdilik tam sayfa yenileme yapıyoruz.
                location.reload(); 
            } else {
                alert(response.message || 'Değerlendirme silinirken bir hata oluştu.');
            }
        })
        .fail(function() {
            alert('Sunucu hatası: Değerlendirme silinemedi.');
        })
        .always(function() {
            button.prop('disabled', false).html('Değerlendirmeyi Sil');
        });
    });
});
</script>
<?= $this->endSection() ?>